document.observe("dom:loaded", function() {
  applyCustomColors();
});

Ajax.Responders.register({
  onComplete: function() {
    applyCustomColors();
  }
});

function applyCustomColors() {
  var elements = $$('.custom-color');
  elements.each(function(item) {
    var bg = item.getStyle('background-color');
    var row = item.up('tr');

    // Define a cor de fundo no <tr>
    row.setStyle({ backgroundColor: bg });

    // --- pegar valores RGB, seja hex ou rgb ---
    var rgb = getRGB(bg);

    if (rgb) {
      var r = rgb[0], g = rgb[1], b = rgb[2];

      // fórmula de luminância perceptiva
      var luminance = (0.299 * r + 0.587 * g + 0.114 * b);

      // se a cor for clara → texto preto, senão branco
      var textColor = (luminance > 186) ? '#000000' : '#FFFFFF';

      // aplica a cor do texto no <tr> inteiro
      row.setStyle({ color: textColor });
    }
  });
}

// Função para converter qualquer formato em array [r,g,b]
function getRGB(color) {
  if (!color) return null;

  // Caso seja no formato rgb(r,g,b)
  if (color.startsWith("rgb")) {
    var parts = color.replace(/[^\d,]/g, '').split(',');
    return [parseInt(parts[0], 10), parseInt(parts[1], 10), parseInt(parts[2], 10)];
  }

  // Caso seja no formato hex #RRGGBB ou #RGB
  if (color.startsWith("#")) {
    var hex = color.replace('#', '');
    if (hex.length === 3) {
      hex = hex.split('').map(function (h) { return h + h; }).join('');
    }
    var bigint = parseInt(hex, 16);
    var r = (bigint >> 16) & 255;
    var g = (bigint >> 8) & 255;
    var b = bigint & 255;
    return [r, g, b];
  }

  return null;
}
