<?php

/**
 * Defcon2_Imaclean
 *
 * @category   Defcon2
 * @package    Defcon2_Imaclean
 * @copyright  Copyright (c) 2016 Manuel Canepa (http://cv.manuelcanepa.com.ar/)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class Defcon2_Imaclean_Adminhtml_ImacleanController extends Mage_Adminhtml_Controller_Action {

    protected function _isAllowed() {
        return Mage::getSingleton('admin/session')->isAllowed('admin/system/d2imaclean');
    }

    protected function _initAction() {
        $this->loadLayout()
            ->_setActiveMenu('defcon2imaclean/items')
            ->_addBreadcrumb(Mage::helper('adminhtml')->__('Items Manager'), Mage::helper('adminhtml')->__('Item Manager'));

        return $this;
    }

    public function indexAction() {
        $this->loadLayout();
        $this->_setActiveMenu('system/d2imaclean');
        $this->_addContent($this->getLayout()->createBlock('defcon2imaclean/adminhtml_imaclean'));
        $this->renderLayout();
    }

    public function newAction() {
        Mage::helper('defcon2imaclean')->compareList();
        $this->_redirect('*/*/');
    }

    public function deleteAction() {
        if ($this->getRequest()->getParam('id') > 0) {
            try {
                $model = Mage::getModel('defcon2imaclean/imaclean');
                $model->load($this->getRequest()->getParam('id'));
                unlink('media/catalog/product' . $model->getFilename());
                $model->setId($this->getRequest()->getParam('id'))->delete();

                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('adminhtml')->__('Item was successfully deleted'));
                $this->_redirect('*/*/');
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                $this->_redirect('*/*/edit', array('id' => $this->getRequest()->getParam('id')));
            }
        }
        $this->_redirect('*/*/');
    }

    public function massDeleteAction() {
        $imacleanIds = $this->getRequest()->getParam('imaclean');
        if (!is_array($imacleanIds)) {
            Mage::getSingleton('adminhtml/session')->addError(Mage::helper('adminhtml')->__('Please select item(s)'));
        } else {
            try {
                $model = Mage::getModel('defcon2imaclean/imaclean');
                foreach ($imacleanIds as $imacleanId) {
                    $model->load($imacleanId);
                    unlink('media/catalog/product' . $model->getFilename());
                    $model->setId($imacleanId)->delete();
                }
                Mage::getSingleton('adminhtml/session')->addSuccess(
                    Mage::helper('adminhtml')->__(
                        'Total of %d record(s) were successfully deleted', count($imacleanIds)
                    )
                );
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
            }
        }
        $this->_redirect('*/*/index');
    }

}
